var canvas, gameContainer, scoreContainer, ctx, audioWin, audioLose

// Canvas property
const canvasSize = 400
const canvasBorder = "3px solid gold"
const canvasBackgroundColor = "#1D1D1D"
const canvasOpacity = "0.8"

// Score property
var score = 0
const scoreColor = "white"

// Snake property
const snakeColor = "orange"
const snakeSize = 20
const blockUnit = canvasSize / snakeSize
var snakeX = Math.trunc(Math.random()*blockUnit)*snakeSize
var snakeY = Math.trunc(Math.random()*blockUnit)*snakeSize

// Food property
var rayonFood = snakeSize / 2
var foodX = Math.trunc(Math.random()*blockUnit)*snakeSize + rayonFood
var foodY = Math.trunc(Math.random()*blockUnit)*snakeSize + rayonFood
// Step property
var stepX = 0
var stepY = 0
// fonction
export const SnakeGame = {
    start : () =>{
        SnakeGame.createMedia()
        SnakeGame.createCanvas()
        SnakeGame.createSnake()
        SnakeGame.moveSnake()
        setInterval(SnakeGame.updateSnakePosition, 100)
    },
    createCanvas: () =>{
        console.log("createCanvas");
        gameContainer = document.createElement("div")
        scoreContainer = document.createElement("div")
        gameContainer.id = "game-container"
        scoreContainer.id = "score"
        scoreContainer.innerHTML = "0"
        scoreContainer.style.color = scoreColor
        scoreContainer.style.fontSize = "50px"
        scoreContainer.style.position = "fixed"        
        scoreContainer.style.zIndex = "999"        
        canvas = document.createElement("canvas")
        canvas.width = canvasSize
        canvas.height = canvasSize
        canvas.style.border = canvasBorder
        canvas.style.backgroundColor = canvasBackgroundColor;
        canvas.style.opacity = canvasOpacity
        // canvas.style.display = "block"
        // canvas.style.marginLeft = "auto"
        // canvas.style.marginRight = "auto"
        gameContainer.style.display = "flex"
        gameContainer.style.justifyContent = "center"
        gameContainer.style.alignItems = "center"
        // gameContainer.style.flexDirection = "column"
        ctx = canvas.getContext("2d")
        gameContainer.appendChild(scoreContainer)
        gameContainer.appendChild(canvas)
        document.body.appendChild(gameContainer)

    }, 
    createMedia: () =>{
        audioWin = document.createElement("audio")
        audioWin.src = "/assets/media/win.mp3"
        audioLose = document.createElement("audio")
        audioLose.src = "/assets/media/lose.mp3"
    },
    createSnake: () =>{
        ctx.fillStyle = snakeColor
        ctx.clearRect(0, 0, canvasSize, canvasSize)
        ctx.fillRect(snakeX, snakeY, snakeSize, snakeSize)
        SnakeGame.createFood()
    },
    createFood: () =>{
        ctx.beginPath()
        ctx.arc(foodX, foodY, rayonFood, 0, 2 * Math.PI)
        ctx.fillStyle = snakeColor
        ctx.fill()
        ctx.closePath()
    },
    createCollision: () =>{
        if(snakeX < 0 || snakeX > (canvasSize - snakeSize) || snakeY < 0 || snakeY > (canvasSize - snakeSize)){
            audioLose.play()
            SnakeGame.updateScore(score - 20)
            stepX = 0
            stepY = 0
            snakeX = Math.trunc(Math.random()*blockUnit)*snakeSize
            snakeY = Math.trunc(Math.random()*blockUnit)*snakeSize
        }
        else if( (foodX - rayonFood === snakeX) && (foodY - rayonFood === snakeY)){
            SnakeGame.updateScore(score + 10)
            audioWin.play()
            foodX = Math.trunc(Math.random()*blockUnit)*snakeSize + rayonFood
            foodY = Math.trunc(Math.random()*blockUnit)*snakeSize + rayonFood
        }
    },
    updateSnakePosition: () =>{
        snakeX += stepX*snakeSize
        snakeY += stepY*snakeSize
        SnakeGame.createSnake()
        SnakeGame.createCollision()
    },
    moveSnake: () =>{
        document.addEventListener("keydown", (evt) => {
            console.log(evt.key)
            switch (evt.key){
                case "ArrowUp":
                    stepY = -1
                    stepX = 0
                    break
                case "ArrowDown": 
                stepY = 1
                stepX = 0
                break
                case "ArrowLeft":
                    stepY = 0
                    stepX = -1
                    break
                case "ArrowRight":
                    stepY = 0
                    stepX = 1
                    break
                case " ":
                    stepY = 0
                    stepX = 0
                default:
                    break
            }
        })
    }, 
    updateScore: (newScore) =>{
        if(newScore !== score){
            scoreContainer.innerHTML = newScore
           score = newScore
        }
    }

}